unit Unit1;

interface

uses
  SysUtils, Classes, HTTPApp, HTTPProd;

type
  TWebModule1 = class(TWebModule)
    FormPageProducer: TPageProducer;
    AddedPageProducer: TPageProducer;
    ErrorPageProducer: TPageProducer;
    ListPageProducer: TPageProducer;
    RemovedPageProducer: TPageProducer;
    AboutPageProducer: TPageProducer;
    procedure WebModule1PostAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure AddedPageProducerHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule1ListAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
  private
    { Private declarations }
    procedure ZapiszDoPliku(email, nazwisko :String);
    procedure UsunZPliku(email, nazwisko :String);
  public
    { Public declarations }
  end;

const
  datafilename='Project1.txt';

var
  WebModule1: TWebModule1;

implementation

{$R *.dfm}

procedure TWebModule1.WebModule1PostAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  email,nazwisko :String;
  email_correct,akcja :Boolean;
begin
email:=Request.ContentFields.Values['email'];
email_correct:=True;
nazwisko:=Request.ContentFields.Values['nazwisko'];
if Request.ContentFields.Values['akcja']='dodaj' then akcja:=True
                                                 else akcja:=False;

if akcja
  then //dodawanie do listy
  begin
    if (Pos('@',email)=0) or (Pos('.',email)=0) then email_correct:=False;
    if (Request.ContentFields.Values['nazwisko']<>'') and email_correct
      then
        begin
        Response.Content:=AddedPageProducer.Content;
        ZapiszDoPliku(email,nazwisko);
        end
      else Response.Content:=ErrorPageProducer.Content;
  end
  else //usuwanie z listy pierwszego napotkanego
  begin
    UsunZPliku(email,nazwisko);
    Response.Content:=RemovedPageProducer.Content;
  end;
end;


procedure TWebModule1.AddedPageProducerHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
if TagString='tytul' then ReplaceText:='Jacek Matulewski - Lista mailowa';
if TagString='naglowek' then ReplaceText:='Lista mailowa';
if TagString='email' then ReplaceText:=Request.ContentFields.Values['email'];
if TagString='nazwisko' then ReplaceText:=Request.ContentFields.Values['nazwisko'];
end;

procedure TWebModule1.ZapiszDoPliku(email,nazwisko :String);
var tf: TextFile;
begin
AssignFile(tf,datafilename); //W TurboPascalu bylo Assign, ale jest taka metoda w VCL
if FileExists(datafilename)
  then Append(tf)
  else Rewrite(tf);
WriteLn(tf,email+' ('+nazwisko+')');
CloseFile(tf); //W TurboPascalu bylo Open, ale np. forma ma taka metode
end;

procedure TWebModule1.WebModule1ListAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  tf: TextFile;
  linia :String;
begin
//ListPageProducer.HTMLDoc.Clear;
//ListPageProducer.HTMLDoc.Add('<HTML><HEAD><TITLE>Jacek Matulewski - Lista e-mailowa</TITLE></HEAD>');
//ListPageProducer.HTMLDoc.Add('<BODY><H2>Lista mailowa:</H2><B>Lista adresw e-mail:</B><BR>');

AssignFile(tf,datafilename);
if FileExists(datafilename) then
  begin
  Reset(tf);
  while not Eof(tf) do
    begin
    ReadLn(tf,linia);
    ListPageProducer.HTMLDoc.Add(linia+'<BR>')
    end;
  CloseFile(tf);
  end
  else ListPageProducer.HTMLDoc.Add('<I>Lista jest pusta</I>');
ListPageProducer.HTMLDoc.Add('</BODY></HTML>');

Response.Content:=ListPageProducer.Content;
end;

procedure TWebModule1.UsunZPliku(email,nazwisko :String);
var
  tf: TextFile;
  linia,szukany :String;
  bufor :TStringList;
begin
szukany:=email+' ('+nazwisko+')';
linia:='';
bufor:=TStringList.Create;
bufor.Clear;

AssignFile(tf,datafilename);
if not FileExists(datafilename)
  then Exit
  else
    begin
    Reset(tf);
    while not Eof(tf) do
      begin
      ReadLn(tf,linia);
      if (linia<>szukany) and (linia<>'') then bufor.Add(linia); //przy okazju wyrzucamy puste
      end;
    CloseFile(tf);
    bufor.SaveToFile(datafilename);
    end;
end;


end.


